using System;
using System.Data;

namespace gov.va.med.vbecs.BOL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/23/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Ragent Change class deals with the changes that take place to a reagent</summary>

		#endregion

	public class ReagentChange : BaseBusinessObject
	{
		/// <summary>
		/// The list of columns
		/// </summary>
		public const string REAGENTCHANGECOLUMNS = "ReagentChangeGuid,ReagentGuid,ReagentChangeDetailCode";

		private Guid _reagentChangeGUID;
		private Guid _reagentGUID;
		private string _reagentChangeDetailCode;

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1260"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Valid ReagentChange object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="762"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Empty constructor
		/// </summary>
        public ReagentChange()
		{
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2419"> 
		///		<ExpectedInput>DataRow containing ReagentChange data</ExpectedInput>
		///		<ExpectedOutput>ReagentChange object</ExpectedOutput>
		///	</Case>
		///		
		///<Case type="1" testid ="2878"> 
		///		<ExpectedInput>Null</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates ReagentChange object and populates it with data from DataRow
		/// </summary>
		public ReagentChange(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1067"> 
		///		<ExpectedInput>Valid GUID</ExpectedInput>
		///		<ExpectedOutput>Valid GUID</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="933"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Reagent Change GUID
		/// </summary>
		public Guid ReagentChangeGuid
		{
			get
			{
				return _reagentChangeGUID;
			}
			set
			{
				_reagentChangeGUID = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1068"> 
		///		<ExpectedInput>Valid GUID</ExpectedInput>
		///		<ExpectedOutput>Valid GUID</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="974"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Reagent GUID
		/// </summary>
		public Guid ReagentGuid
		{
			get
			{
				return _reagentGUID;
			}
			set
			{
				_reagentGUID = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1069"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="931"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Reagent Change Detail Code
		/// </summary>
		public string ReagentChangeDetailCode
		{
			get
			{
				return _reagentChangeDetailCode;
			}
			set
			{
				_reagentChangeDetailCode = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1070"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Valid DataTable</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="853"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Initialize Reagent Change Table
		/// </summary>
		/// <returns></returns>
		public static DataTable InitializeReagentChangeTable()
		{
			DataTable dtReagentChange = new DataTable("ReagentChange");
			dtReagentChange.Columns.Add(Common.VbecsTables.ReagentChange.ReagentChangeGuid, typeof(Guid));
			dtReagentChange.Columns.Add(Common.VbecsTables.ReagentChange.ReagentGuid, typeof(Guid));
			dtReagentChange.Columns.Add(Common.VbecsTables.ReagentChange.ReagentChangeDetailCode);
			dtReagentChange.Columns.Add(Common.VbecsTables.ReagentChange.Comments);
			dtReagentChange.Columns.Add(Common.VbecsTables.ReagentChange.LastUpdateDate, typeof(DateTime));

			return dtReagentChange;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1071"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Valid DataTable</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="825"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get Reagent Change Details
		/// </summary>
		/// <returns></returns>
		public static DataTable GetReagentChangeDetails()
		{
			return DAL.ReagentChange.GetReagentChangeDetails();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="1263"> 
		///		<ExpectedInput>Valid data row</ExpectedInput>
		///		<ExpectedOutput>Valid data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2877"> 
		///		<ExpectedInput>Invalid DataRow</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			dtRow[Common.VbecsTables.ReagentChange.ReagentChangeGuid] = this.ReagentChangeGuid;
			dtRow[Common.VbecsTables.ReagentChange.ReagentGuid] = this.ReagentGuid;
			dtRow[Common.VbecsTables.ReagentChange.ReagentChangeDetailCode] = this.ReagentChangeDetailCode;
			dtRow[Common.VbecsTables.ReagentChange.Comments] = this.Comments;
			dtRow[Common.VbecsTables.ReagentChange.LastUpdateDate] = this.LastUpdateDate;

			return dtRow;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads an object from a data row
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			this.ReagentChangeGuid = dtRow.IsNull(Common.VbecsTables.ReagentChange.ReagentChangeGuid) ? System.Guid.Empty : (System.Guid)dtRow[Common.VbecsTables.ReagentChange.ReagentChangeGuid];
			this.ReagentGuid = dtRow.IsNull(Common.VbecsTables.ReagentChange.ReagentGuid) ? System.Guid.Empty : (System.Guid)dtRow[Common.VbecsTables.ReagentChange.ReagentGuid];
			this.ReagentChangeDetailCode = dtRow.IsNull(Common.VbecsTables.ReagentChange.ReagentChangeDetailCode) ? string.Empty : dtRow[Common.VbecsTables.ReagentChange.ReagentChangeDetailCode].ToString();
			this.Comments = dtRow.IsNull(Common.VbecsTables.ReagentChange.Comments) ? string.Empty : dtRow[Common.VbecsTables.ReagentChange.Comments].ToString();
			this.LastUpdateDate = dtRow.IsNull(Common.VbecsTables.ReagentChange.LastUpdateDate) ? DateTime.MinValue : (DateTime)dtRow[Common.VbecsTables.ReagentChange.LastUpdateDate];
		}


		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1262"> 
		///		<ExpectedInput>string array of column names, Valid data table</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2873"> 
		///		<ExpectedInput>Invalid datatable</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Checks the columns in the data table against a string array of column names
		/// </summary>
		public bool VerifyMinColumnsInDataTable(string [] colNames, System.Data.DataTable dtTable)
		{
			return Common.Utility.VerifyMinColumnsInDataTable(REAGENTCHANGECOLUMNS.Split(','), dtTable);
		}	

	}
}



